/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于解析hub描述信息xml文件
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020-3-11
 *      内容 : 所有代码
 ************************************************************************************************/
/* exported mc_sdk_hub */

function mc_sdk_hub() {
    var TAGNAME_PINS = "pins";
    var TAGNAME_CHILD_PIN = "child_pin";
    var TAGNAME_DAT = "dat";
    var TAGNAME_CTL = "ctl";
    var TAGNAME_ITEM = "item";
    var PINS_ATTR_NAME = "name";
    var PINS_ATTR_ICCOUNT = "iccount";
    var CHILD_PIN_ATTR_SUBNAME = "subname";
    var CHILD_PIN_ATTR_USE_DAT_PIN_COUNT = "use_dat_pin_count";
    var CHILD_PIN_ATTR_USE_CTL_PIN_COUNT = "use_ctl_pin_count";
    var ITEM_ATTR_VALUE = "value";
    var obj_domParser = new DOMParser();
    var m_obj_hub_msg = {
        str_name: "",
        str_iccount: "",
        str_all_use_dat_cnt: "",
        ary_child_pin: []
    };

    /**
     * 解析xml数据,并存入
     * @param {promises<string>} str_xml_req  xml转数据
     * @returns {promises<boolean>} 存入结果
    */
    this.set_hub_xml = function (str_xml_req) {
        if ("string" !== typeof str_xml_req || 0 >= str_xml_req.length) {
            return false;
        }
        // 解析xml文件
        var obj_xml_data = obj_domParser.parseFromString(str_xml_req, "text/xml");
        // 获取文件下pins标签
        var obj_pins_data = obj_xml_data.getElementsByTagName(TAGNAME_PINS)[0];

        // 判断当前 dat / ctl 是否请求有数据
        var b_if_dat_exict = false;
        // var b_if_ctl_exict = false;

        if (!obj_pins_data) {
            return false;
        }
        // 获取pins标签中的属性
        m_obj_hub_msg.str_name = obj_pins_data.getAttribute(PINS_ATTR_NAME);
        m_obj_hub_msg.str_iccount = obj_pins_data.getAttribute(PINS_ATTR_ICCOUNT);

        // 获取pins标签下所有child_pin标签
        var ary_child_pin = obj_pins_data.getElementsByTagName(TAGNAME_CHILD_PIN);
        var ui_all_use_dat_pin_cnt = 0;

        for (var idx_child_pin = 0; idx_child_pin < ary_child_pin.length; idx_child_pin++) {
            // 获取child_pin标签下属性及 两个子标签内容
            var obj_child_pin = ary_child_pin[idx_child_pin];
            var str_subname = obj_child_pin.getAttribute(CHILD_PIN_ATTR_SUBNAME);
            var str_use_dat_pin_count = obj_child_pin.getAttribute(CHILD_PIN_ATTR_USE_DAT_PIN_COUNT);
            var str_use_ctl_pin_count = obj_child_pin.getAttribute(CHILD_PIN_ATTR_USE_CTL_PIN_COUNT);
            var obj_dat_tag = obj_child_pin.getElementsByTagName(TAGNAME_DAT)[0];
            var obj_ctl_tag = obj_child_pin.getElementsByTagName(TAGNAME_CTL)[0];
            var ary_dat_item = [];
            var ary_ctl_item = [];

            var idx_get_item_val = 0;
            var obj_item_tag = {};

            try {
                var ary_dat_item_tag = obj_dat_tag.getElementsByTagName(TAGNAME_ITEM);

                // dat有数据请求回来
                for (idx_get_item_val = 0; idx_get_item_val < ary_dat_item_tag.length; idx_get_item_val++) {
                    obj_item_tag = ary_dat_item_tag[idx_get_item_val];
                    ary_dat_item[idx_get_item_val] = obj_item_tag.getAttribute(ITEM_ATTR_VALUE);
                    b_if_dat_exict = true;
                }
            } catch (error) {
                if (!isNaN(Number(str_use_dat_pin_count))) {
                    ary_dat_item = new Array(Number(str_use_dat_pin_count));
                } else {
                    str_use_dat_pin_count = "256";
                    ary_dat_item = new Array(256);
                }
            }
            try {
                var ary_ctl_item_tag = obj_ctl_tag.getElementsByTagName(TAGNAME_ITEM);

                // ctl有数据请求回来
                for (idx_get_item_val = 0; idx_get_item_val < ary_ctl_item_tag.length; idx_get_item_val++) {
                    obj_item_tag = ary_ctl_item_tag[idx_get_item_val];
                    ary_ctl_item[idx_get_item_val] = obj_item_tag.getAttribute(ITEM_ATTR_VALUE);
                    // b_if_ctl_exict = true;
                }
            } catch (error) {
                str_use_ctl_pin_count = "0";
                ary_ctl_item = [];
            }
            var ary_st_dat = [];
            var ary_st_ctl = [];
            var str_item_value = "";

            for (var idx_dat = 0; idx_dat < Number(str_use_dat_pin_count); idx_dat++) {
                var str_dat_val = ary_dat_item[idx_dat];

                if (!str_dat_val) {
                    // 请求有数据不够用 则给65535 ; 请求没有数据但要使用就按顺序给
                    if (b_if_dat_exict) {
                        str_dat_val = "65535";
                    } else {
                        str_dat_val = idx_dat + "";
                    }
                }
                str_item_value = str_dat_val;
                ary_st_dat.push(str_item_value);
            }

            // 根据使用数量来断定是否需要添加
            for (var idx_ctl = 0; idx_ctl < Number(str_use_ctl_pin_count); idx_ctl++) {
                str_item_value = ary_ctl_item[idx_ctl];
                // 请求有数据不够用 则给16 请求没有数据但要使用就按顺序给
                if (!str_item_value) {
                    str_item_value = "16";
                }
                ary_st_ctl.push(str_item_value);
            }
            m_obj_hub_msg.ary_child_pin.push({
                str_subname: str_subname,
                str_use_dat_pin_count: str_use_dat_pin_count,
                str_use_ctl_pin_count: str_use_ctl_pin_count,
                ary_st_dat: ary_st_dat,
                ary_st_ctl: ary_st_ctl

            });
            ui_all_use_dat_pin_cnt += Number(str_use_dat_pin_count);
        }
        m_obj_hub_msg.str_all_use_dat_cnt = ui_all_use_dat_pin_cnt + "";
        return true;
    };

    /**
     * 获取xml字符串
     * @returns {promises<string>} 生成xml字串
    */
    this.get_hub_xml = function () {
        var str_xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" +
            "<pins name=\"" + m_obj_hub_msg.str_name + "\" iccount=\"" + m_obj_hub_msg.str_iccount + "\">\n";

        // 存入所有child_pin标签
        var ary_child_data = m_obj_hub_msg.ary_child_pin;

        for (var idx_child = 0; idx_child < ary_child_data.length; idx_child++) {
            var obj_child = ary_child_data[idx_child];

            // 存入child_pin标签属性
            str_xml += "<child_pin subname=\"" + obj_child.str_subname + "\" use_dat_pin_count=\"" + obj_child.str_use_dat_pin_count + "\" use_ctl_pin_count=\"" + obj_child.str_use_ctl_pin_count + "\">\n<dat>\n";

            var str_item_value = "";

            // 存入每个child_pin标签下的dat标签
            var ary_dat = obj_child.ary_st_dat;

            for (var idx_dat = 0; idx_dat < ary_dat.length; idx_dat++) {
                str_item_value = ary_dat[idx_dat];

                str_xml += "<item value=\"" + str_item_value + "\" />\n";
            }
            str_xml += "</dat>\n<ctl>\n";

            // 存入每个child_pin标签下的ctl标签
            var ary_ctl = obj_child.ary_st_ctl;

            for (var idx_ctl = 0; idx_ctl < ary_ctl.length; idx_ctl++) {
                str_item_value = ary_ctl[idx_ctl];

                str_xml += "<item value=\"" + str_item_value + "\" />\n";
            }
            str_xml += "</ctl>\n</child_pin>\n";
        }

        str_xml += "</pins>";

        return str_xml;
    };
    /**
     * 获取解析完成的数据
     * @returns {promises<Object>} 存入的数据
    */
    this.get_hub_msg = function () {
        return m_obj_hub_msg;
    };
    /**
     * 存入数据
     * @param {Promise<Object>} obj_hub_msg 内部识别对象
     * @returns {promises<Object>} 存入的数据
    */
    this.set_hub_msg = function (obj_hub_msg) {
        m_obj_hub_msg = obj_hub_msg;
        return m_obj_hub_msg;
    };
    /**
     * 存入hub卡名称
     * @param {Promise<String>} str_hub_name hub卡名称
    */
    this.set_pins_name_default = function (str_hub_name) {
        m_obj_hub_msg.str_name = str_hub_name;
    };
}
